﻿using VeteransAffairs.Registries.BusinessAHOBPR;
using VeteransAffairs.Registries.BusinessManagerAHOBPR.Emis;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using VeteransAffairs.Registries.BusinessManagerAHOBPR;
namespace WCF_BusinessManagerAHOBPRTests
{
    [TestClass]
    public class RegistrantDeploymentUtilitiesTests
    {
        string con = "Data Source=DNS;Initial Catalog=Registry_AHOBPRHRE;Integrated Security=True;Encrypt=yes;TrustServerCertificate=True";
        //[TestMethod]
        //public void VerifyDeploymentStage_IfUserIsElibibleAndVerified_DeploymentIsSetToVerified()
        //{
        //    var cut = new RegistrantDeploymentUtilities(con);
        //    var deployment = new REGISTRANT_DEPLOYMENT();
        //    deployment.STD_DEPLOYMENT_STAGE_ID = 42;
        //    deployment.REGISTRANT_DEPLOYMENT_ID = 509544;
        //    deployment.USER_VERIFIED_FLAG = true;
        //    deployment.IS_ELIGIBLE_FLAG = true;
        //    cut.VerifyDeploymentStage(deployment);
        //    Assert.AreEqual((int)Enums.DeploymentStage.Verified, deployment.STD_DEPLOYMENT_STAGE_ID);
        //}
        [TestMethod]
        public void VerifyDeploymentStage_IfDeploymentIsNElibibleAndVerifiedDeploymentIsSetToVerified()
        {      
            var cut = new RegistrantDeploymentUtilities(con);
            var deployment = new REGISTRANT_DEPLOYMENT();
            deployment.STD_DEPLOYMENT_STAGE_ID = 42;
            deployment.REGISTRANT_DEPLOYMENT_ID = 509544;
            deployment.USER_VERIFIED_FLAG = false;
            deployment.IS_ELIGIBLE_FLAG = true;
            cut.VerifyDeploymentStage(deployment);
            Assert.AreEqual((int)Enums.DeploymentStage.Refuted, deployment.STD_DEPLOYMENT_STAGE_ID);
        }
        [TestMethod]
        public void SetDeploymentStage_DeploymentIsN2ElibibleAndVerifiedDeploymentIsSetToVerified()
        {    
            var cut = new RegistrantDeploymentUtilities(con);
            var deployment = new REGISTRANT_DEPLOYMENT();
            deployment.STD_DEPLOYMENT_STAGE_ID = 42;
            deployment.REGISTRANT_DEPLOYMENT_ID = 509544;
            deployment.USER_VERIFIED_FLAG = false;
            deployment.IS_ELIGIBLE_FLAG = true;
            cut.SetDeploymentStage(deployment, 0);
            Assert.AreEqual((int)Enums.DeploymentStage.New, deployment.STD_DEPLOYMENT_STAGE_ID);
        }
        [TestMethod]
        public void SetDeploymentStage_NotEligibleIfUserVerifiedFlagIsSetToFalse()
        {         
            var cut = new RegistrantDeploymentUtilities(con);
            var deployment = new REGISTRANT_DEPLOYMENT();
            deployment.STD_DEPLOYMENT_STAGE_ID = 2;
            deployment.REGISTRANT_DEPLOYMENT_ID = 509544;
            deployment.USER_VERIFIED_FLAG = false;
            deployment.IS_ELIGIBLE_FLAG = true;
            cut.SetDeploymentStage(deployment, 0);
            Assert.AreEqual((int)Enums.DeploymentStage.NotEligible, deployment.STD_DEPLOYMENT_STAGE_ID);
        }
        [TestMethod]
        public void SetDeploymentStage_RefutedIfUserVerifiedFlagIsSetToFalse()
        {         
            var cut = new RegistrantDeploymentUtilities(con);
            var deployment = new REGISTRANT_DEPLOYMENT();
            deployment.STD_DEPLOYMENT_STAGE_ID = 2;
            deployment.REGISTRANT_DEPLOYMENT_ID = 509544;
            deployment.USER_VERIFIED_FLAG = false;
            deployment.IS_ELIGIBLE_FLAG = true;
            cut.SetDeploymentStage(deployment, 7);
            Assert.AreEqual((int)Enums.DeploymentStage.Refuted, deployment.STD_DEPLOYMENT_STAGE_ID);
        }
        //[TestMethod]
        //public void SetDeploymentStage_IsN5ElibibleAndVerifiedDeploymentIsSetToVerified()
        //{
        //    var cut = new RegistrantDeploymentUtilities(con);
        //    var deployment = new REGISTRANT_DEPLOYMENT();
        //    deployment.STD_DEPLOYMENT_STAGE_ID = (int)Enums.DeploymentStage.NotEligible;
        //    deployment.REGISTRANT_DEPLOYMENT_ID = 509544;
        //    deployment.USER_VERIFIED_FLAG = true;
        //    deployment.IS_ELIGIBLE_FLAG = true;
        //    cut.SetDeploymentStage(deployment, 7);
        //    Assert.AreEqual((int)Enums.DeploymentStage.Verified, deployment.STD_DEPLOYMENT_STAGE_ID);
        //}
    }
}
